; *** Mac-OS-X-Update fr Windows (MauWi) 1.0                        ***
; *** Autor: Andreas Ltteken (andreas.luetteken[at]libero.it)       ***
; *** Coding inspiriert vom c't Offline-Update 3.0 (www.heise.de/ct) ***
; *** Teile sind (c) T. Wittrock, RZ Uni Kiel                        ***

#include <GUIConstants.au3>

Dim Const $caption = "Mac-OS-X-Update fr Windows 1.0"
Dim Const $txtwidth = 280, $txtheight = 20
Dim Const $txtxoffset = 20, $txtyoffset = 20

Dim $maindlg, $ppc, $intel, $dvdiso, $ppcopt, $intelopt, $dvdisoopt, $btn_settings, $btn_start, $btn_exit
Dim $Settings, $FHandle, $options, $folder, $error
Dim $proxy, $ProxyUser, $ProxyName, $ProxyPort, $PWord
Dim $txtypos = $txtyoffset

Func ToggleStartButton()
	; Der Start-Button wird deaktiviert, wenn weder die Intel- noch die PowerPC-Option ausgewhlt ist.
	If ( (BitAND(GUICtrlRead($ppc), $GUI_CHECKED) <> $GUI_CHECKED) AND (BitAND(GUICtrlRead($intel), $GUI_CHECKED) <> $GUI_CHECKED) ) then
		GUICtrlSetState($btn_start, $GUI_DISABLE)
	Else
		GUICtrlSetState($btn_start, $GUI_ENABLE)
	EndIf
	Return 0
EndFunc

Func DisableGUI()
	; Alle Fensterlemente werden deaktiviert.
	GUICtrlSetState($ppc, $GUI_DISABLE)
	GUICtrlSetState($intel, $GUI_DISABLE)
	GUICtrlSetState($dvdiso, $GUI_DISABLE)
	GUICtrlSetState($btn_settings, $GUI_DISABLE)
	GUICtrlSetState($btn_start, $GUI_DISABLE)
	GUICtrlSetState($btn_exit, $GUI_DISABLE)
	Return 0
EndFunc

Func EnableGUI()
	; Alle Fensterlemente werden aktiviert.
	GUICtrlSetState($ppc, $GUI_ENABLE)
	GUICtrlSetState($intel, $GUI_ENABLE)
	GUICtrlSetState($dvdiso, $GUI_ENABLE)
	GUICtrlSetState($btn_settings, $GUI_ENABLE)
	ToggleStartButton()
	GUICtrlSetState($btn_exit, $GUI_ENABLE)
	Return 0
EndFunc

Func ReadSettings()
	; Einstellungen aus der Datei ".\static\settings" auslesen, bei Bedarf das "Einstellungsfenster" (Einstellungen.exe) ffnen
	$Settings=".\static\settings"

	$FHandle= FileOpen($Settings,0)
	if $FHandle <> -1 then
		$folder = FileReadLine($FHandle,2)		
		$ProxyUser = FileReadLine($FHandle,4)
		$ProxyName = FileReadLine($FHandle,5)
		$ProxyPort = FileReadLine($FHandle,6)
		$intelopt = FileReadLine($FHandle,9)
		$ppcopt = FileReadLine($FHandle,11)
		$dvdisoopt = FileReadLine($FHandle,13)
		FileClose($FHandle)
	Else
		MsgBox("OK","Einstellungen","Sie mssen noch die Einstellungen fr Proxy und Volume-Namen vornehmen.")
		DisableGUI()
		RunWait(".\bin\settings.exe")
		ReadSettings()
		EnableGUI()
	EndIf
	Return 0
EndFunc

Func WriteStates()
	; Die ausgewhlten Optionen in der Datei ".\static\settings" speichern
	Dim $lines[14], $i
		
	; zuerst die Datei lesen
	$FHandle= FileOpen($settings,0)
	If $FHandle <> -1 then
		for $i = 1 to 13
			$lines[$i] = FileReadLine($FHandle,$i)
		next
		FileClose($FHandle)
	EndIf

	$FHandle= FileOpen($settings,2)
	; anschlieend bis auf die Zeilen 9, 11 und 13 die Originalwerte zurckschreiben
	If $FHandle <> -1 then
		for $i = 1 to 8
			FileWriteLine($FHandle,$lines[$i])
		next

		FileWriteLine($FHandle,BitAND(GUICtrlRead($intel), $GUI_CHECKED))
		FileWriteLine($FHandle,$lines[10])
		FileWriteLine($FHandle,BitAND(GUICtrlRead($ppc), $GUI_CHECKED))
		FileWriteLine($FHandle,$lines[12])
		FileWriteLine($FHandle,BitAND(GUICtrlRead($dvdiso), $GUI_CHECKED))
		FileClose($FHandle)
	EndIf
	Return 0
EndFunc

Func HandleDownload($opts, $prox, $winTitle)
	; Dateien per Batch-Skript "download.cmd" herunterladen
	Dim $result = 1

	WinSetTitle($maindlg, $maindlg, $winTitle)
	DisableGUI()
	$result = RunWait(@ComSpec & " /C download.cmd " & $opts & " " & $prox, @ScriptDir & "\cmd", @SW_SHOW)
	WinSetTitle($maindlg, $maindlg, $caption)
	EnableGUI()

	Return $result
EndFunc

;
; Hier beginnt das Hauptprogramm!
;

; Einstellungen einlesen
ReadSettings()

; Fenster mit Bedienelementen anlegen
$maindlg = GUICreate($caption, 320, 180, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE - $WS_SIZEBOX - $WS_MAXIMIZEBOX)
GUISetFont(9, 400, 0, "Sans Serif")

GUICtrlCreateLabel("Mac-OS-X-Updates herunterladen fr...", $txtxoffset, $txtypos, $txtwidth, $txtheight)
$txtypos = $txtypos + $txtyoffset

$ppc = GUICtrlCreateCheckbox("PowerPC-Prozessoren", $txtxoffset + 10, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $ppcopt)
$txtypos = $txtypos + $txtyoffset

$intel = GUICtrlCreateCheckbox("Intel-Prozessoren", $txtxoffset + 10, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $intelopt)
$txtypos = $txtypos +  $txtyoffset

GUICtrlCreateLabel("_________________________________________", $txtxoffset, $txtypos - 5, $txtwidth, $txtheight)
$txtypos = $txtypos + $txtyoffset

$dvdiso = GUICtrlCreateCheckbox("ISO-Datei zum Brennen einer DVD erstellen", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $dvdisoopt)
$txtypos = $txtypos + 2 * $txtyoffset

$btn_start = GUICtrlCreateButton("Start", $txtxoffset, $txtypos, 80, 30)
GUICtrlSetState(-1, $GUI_DEFBUTTON) 
ToggleStartButton()

$btn_settings = GUICtrlCreateButton("Einstellungen", 120, $txtypos, 85, 30)
$btn_exit = GUICtrlCreateButton("Beenden", 220, $txtypos, 80, 30)

; Fenster anzeigen
GUISetState()

; Sicherstellen, dass alle Verzeichnisse vorhanden sind
If Not FileExists("Packages") Then DirCreate("Packages")
If Not FileExists("logs") Then DirCreate("logs")
If Not FileExists("index") Then DirCreate("index")

While 1
	; Hat der Benutzer irgendwo in unserem Fenster geklickt?
	$msg = GUIGetMsg()

	$error = 0

	Select
		Case $msg = $GUI_EVENT_CLOSE
			; Fenster wurde geschlossen
			; Status der Optionen speichern
			WriteStates()
			ExitLoop
		Case $msg = $btn_exit
			; Beenden-Button wurde geklickt
			; Status der Optionen speichern
			WriteStates()
			ExitLoop
		Case $msg = $btn_settings
			; Einstellungen-Button wurde geklickt
			DisableGUI()
			RunWait("bin\settings.exe")
			ReadSettings()
			EnableGUI()
		Case $msg = $ppc
			; Option "PowerPC-Prozessoren" wurde aus- oder angeschaltet
			ToggleStartButton()
		Case $msg = $intel
			; Option "Intel-Prozessoren" wurde aus- oder angeschaltet
			ToggleStartButton()
		Case $msg = $btn_start
			; Start-Button wurde geklickt
			
			; Alte Datei lschen
			If FileExists("start.sucatalog") Then FileDelete("start.sucatalog")

			; Kommt ein Proxy zum Einsatz?
			if $ProxyName <> "" And $ProxyPort <> 0 Then
				if $ProxyUser <> "" Then
					; Wenn ein Proxy-Benutzer eingetragen ist, wird dessen Passwort abgefragt.
					$PWord = InputBox("Passwort-Eingabe","Bitte das Passwort fr den Benutzer " & $ProxyUser & " eingeben:","","*M","-1","-1","-1","-1")
					if @Error = 1 then ContinueLoop
					$proxy = "http://" & $ProxyUser & ":" & $PWord & "@" & $ProxyName & ":" & $ProxyPort
				Else
					; Kein Proxy-Passwort ntig
					$proxy = "http://" & $ProxyName & ":" & $ProxyPort
				EndIf
			Else
				; Kein Proxy-Server und -Port eingetragen
				$proxy = ""
			EndIf

			; Sicherstellen, dass msxsl.exe im Verzeichnis "bin" liegt
			If Not FileExists("bin\msxsl.exe") Then 
				if $proxy = "" then 
					$error = RunWait(@ComSpec & " /C wget.exe -o ..\logs\wget_msxsl.log -N -i ..\static\msxsl_static.txt -O msxsl.exe", @ScriptDir & "\bin", @SW_HIDE)
				Else 
					$error = RunWait(@ComSpec & " /C wget.exe -o ..\logs\wget_msxsl.log -e http_proxy=" & $proxy & " --proxy=on -N -i ..\static\msxsl_static.txt -O msxsl.exe", @ScriptDir & "\bin", @SW_HIDE)
				EndIf

				If $error <> 0 Then
					; Bei Fehler MauWi beenden, denn ohne msxsl.exe geht nix
					MsgBox(0x2010, "Fehler", "Fehler beim Herunterladen der Anwendung 'msxsl.exe' (" & $error & ").")
					Exit
				EndIf
			EndIf
			
			; Software Update Catalog vom Apple-Server laden
			if $proxy = "" Then 
				$error = RunWait(@ComSpec & " /C wget.exe -o ..\logs\wget_sucatalog.log -N -i ..\static\sucatalog_static.txt -O ..\sumirror.sucatalog", @ScriptDir & "\bin", @SW_HIDE)
			Else 
				$error = RunWait(@ComSpec & " /C wget.exe -o ..\logs\wget_sucatalog.log -e http_proxy=" & $proxy & " --proxy=on -N -i ..\static\sucatalog_static.txt -O ..\sumirror.sucatalog", @ScriptDir & "\bin", @SW_HIDE)
			EndIf
			
			If $error <> 0 Then
				; Bei Fehler MauWi beenden, denn ohne Software Update Catalog geht schon gar nix
				MsgBox(0x2010, "Fehler", "Fehler beim Herunterladen des Software Update Catalog (" & $error & ").")
				Exit
			EndIf
			
			; dist-Dateien herunterladen
			$error = HandleDownload("dist", $proxy, "Lade Distributionsdateien...")
			If $error <> 0 Then
				MsgBox(0x2010, "Fehler", "Fehler beim Herunterladen der Distributionsdateien!")
				ContinueLoop
			EndIf

			; Bei aktivierter PowerPC-Option die PowerPC-Updates herunterladen
			If BitAND(GUICtrlRead($ppc), $GUI_CHECKED) = $GUI_CHECKED Then
				$error = HandleDownload("ppc", $proxy, "Lade PowerPC-Updates...")
				If $error <> 0 Then
					MsgBox(0x2010, "Fehler", "Fehler beim Herunterladen der Updates fr PowerPC-Macs (" & $error & ").")
					ContinueLoop
				EndIf
			EndIf

			; Bei aktivierter Intel-Option die Intel-Updates herunterladen
			If BitAND(GUICtrlRead($intel), $GUI_CHECKED) = $GUI_CHECKED Then
				$error = HandleDownload("intel", $proxy, "Lade Intel-Updates...")
				If $error <> 0 Then
					MsgBox(0x2010, "Fehler", "Fehler beim Herunterladen der Updates fr Intel-Macs (" & $error & ").")
					ContinueLoop
				EndIf
			EndIf

			; Jetzt noch alle restlichen Updates laden (QuickTime, iApps, Treiber, etc., aber ohne Updates fr Mac OS X Server)
			$error = HandleDownload("apps", $proxy, "Lade Updates fr Anwendungen, etc...")
			If $error <> 0 Then
				MsgBox(0x2010, "Fehler", "Fehler beim Herunterladen der Updates fr Anwendungen (" & $error & ").")
				ContinueLoop
			EndIf

			; Datei "start.sucatalog" generieren und erstellen
			
			; Wenn MauWi keine DVD erstellen soll, wird das Unterverzeichnis, in dem sich MauWi befindet, bentigt
			; Ausserdem mssen die \ durch / und Leerzeichen durch %20 ersetzt werden, um eine korrekte URL zu erzeugen.
			
			if BitAND(GUICtrlRead($dvdiso), $GUI_CHECKED) <> $GUI_CHECKED Then
				$folder= StringReplace(StringReplace($folder&StringMid(@ScriptDir,3),"\","/")," ","%20")
			EndIf
			
			$error = RunWait(@ComSpec & " /c cmd\postdownload.cmd " & $folder, @ScriptDir, @SW_SHOW)
			If $error <> 0 Then
				MsgBox(0x2010, "Fehler", "Fehler beim Anlegen der Datei 'start.sucatalog' (" & $error & ").")
				ContinueLoop
			EndIf
	  
			; "sumirror.sucatalog" wird nicht lnger bentigt
			If FileExists("sumirror.sucatalog") Then FileDelete("sumirror.sucatalog")
	
			; Soll MauWi eine ISO-Datei erstellen?
			If BitAND(GUICtrlRead($dvdiso), $GUI_CHECKED) = $GUI_CHECKED Then
				; Das geht aber nur, wenn mkisofs.exe im Verzeichnis bin liegt.
				If not FileExists(".\bin\mkisofs.exe") Then
					MsgBox(0x2010, "Fehler", "Das Programm mkisofs.exe fehlt im Verzeichnis \bin. Eine Image-Datei kann deshalb nicht erstellt werden.")
					ContinueLoop
				EndIf
				
				WinSetTitle($maindlg, $maindlg, "Erstelle ISO-Image zum Brennen einer DVD ...")
				DisableGUI()
				$error = RunWait(@ComSpec & " /C mkisofs.exe -iso-level 4 -joliet -joliet-long -rational-rock -exclude-list ..\static\exclude-list.txt -allow-multidot -output " & chr(34) & "..\" & $folder & ".iso" & chr(34) & " -volid " & chr(34) & $folder & chr(34) & " " & chr(34) & @ScriptDir & chr(34) & "  2>&1 | tee.exe ..\logs\mkisofs.log", @ScriptDir & "\bin", @SW_SHOW)
				EnableGUI()
				WinSetTitle($maindlg, $maindlg, $caption)
				If $error <> 0 Then
					MsgBox(0x2010, "Fehler", "Das Erstellen der ISO-Datei ist fehlgeschlagen (" & $error & ").")
					If FileExists(".\" & $folder & ".iso") Then FileDelete(".\" & $folder & ".iso")
					ContinueLoop
				EndIf
			EndIf
	
			if $error = 0 Then MsgBox(0x2040, "Fertig", "Alles erledigt. Fehler scheinen nicht aufgetreten zu sein.")
	EndSelect
WEnd

exit